using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace MoodLight
{
    /// <summary>
    /// To jest gwny typ Twojej gry
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat gry - nasze wartoci kolorw
        byte redIntensity = 0;
        byte greenIntensity = 0;
        byte blueIntensity = 0;

        Texture2D jakeTexture;
        Rectangle jakeRect;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Pozwala grze wykona dowoln inicjalizacj jakiej potrzebuje przed rozpoczeciem dziaania.
        /// To tutaj moe ona zada potrzebnych usug i zaadowa zwizan zawarto nie graficzn.
        /// Wywoanie base.Initialize wyliczy wszystkie komponenty i take je zainicjuje.
        /// </summary>
        protected override void Initialize()
        {
            jakeRect = new Rectangle(
                0,    // wsprzdna X grnego lewego naronika
                0,    // wsprzdna Y grnego lewego naronika
                GraphicsDevice.Viewport.Width,   // szeroko prostokta
                GraphicsDevice.Viewport.Height); // wysoko prostokta

            base.Initialize();
        }

        /// <summary>
        /// LoadContent bedzie wywoany raz na gr i tu naley adowa
        /// ca zawarto.
        /// </summary>
        protected override void LoadContent()
        {
            // Stwrz nowy SpriteBatch, ktrego mona uzy do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            jakeTexture = this.Content.Load<Texture2D>("jake");
        }

        /// <summary>
        /// UnloadContent bedzie wywoany raz na gr i tu naley usuwa 
        /// ca zawarto.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Usun w tym miejscu kad zawarto nie obsugiwan przez ContentManager
        }

        /// <summary>
        /// Pozwala uruchomi w grze logik tak jak aktualizacja wiata,
        /// sprawdzenie kolizji, pobranie wejcia i odtwarzanie dwiku.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Update(GameTime gameTime)
        {
            // Pozwala opusci gr
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
            {
                GamePad.SetVibration(PlayerIndex.One, 0, 0);
                this.Exit();
            }

            GamePadState pad1 = GamePad.GetState(PlayerIndex.One);
            KeyboardState keys = Keyboard.GetState();

            if (keys.IsKeyDown(Keys.Escape)) Exit();

            if (pad1.Buttons.B == ButtonState.Pressed ||
                keys.IsKeyDown(Keys.R)) redIntensity++;

            if (pad1.Buttons.X == ButtonState.Pressed ||
                keys.IsKeyDown(Keys.B)) blueIntensity++;

            if (pad1.Buttons.A == ButtonState.Pressed ||
                keys.IsKeyDown(Keys.G)) greenIntensity++;

            if (pad1.Buttons.Y == ButtonState.Pressed ||
                keys.IsKeyDown(Keys.Y))
            {
                redIntensity++;
                greenIntensity++;
            }

            if (redIntensity > 220 ||
                 greenIntensity > 220 ||
                 blueIntensity > 220)
            {
                GamePad.SetVibration(PlayerIndex.One, 0, 1);
            }
            else
            {
                GamePad.SetVibration(PlayerIndex.One, 0, 0);
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Metoda wywoywana kiedy gra powinna si wyswietli.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Draw(GameTime gameTime)
        {
            Color backgroundColor;
            backgroundColor =
               new Color(redIntensity, greenIntensity, blueIntensity);

            spriteBatch.Begin();
            spriteBatch.Draw(jakeTexture, jakeRect, backgroundColor);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
